<?php
// Add custom field to section
if(!function_exists('grupi_custom_section_params')){
    add_filter('ct-custom-section/custom-params', 'grupi_custom_section_params'); 
    function grupi_custom_section_params(){
        return array(
            'sections' => array(
                array(
                    'name'     => 'ct_row_settings',
                    'label'    => esc_html__( 'Case Settings', 'grupi' ),
                    'tab'      => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name'    => 'header_fixed_transparent',
                            'label'   => esc_html__( 'Header Fixed Transparent', 'grupi' ),
                            'type'    => \Elementor\Controls_Manager::SELECT,
                            'options' => array(
                                'none'        => esc_html__( 'No', 'grupi' ),
                                'transparent'   => esc_html__( 'Yes', 'grupi' ),
                            ),
                            'prefix_class' => 'ct-header-fixed-',
                            'default'      => 'none',
                        ),

                        array(
                            'name'    => 'col_order',
                            'label'   => esc_html__( 'Column Order ( Screen < 1024px)', 'grupi' ),
                            'type'    => \Elementor\Controls_Manager::SELECT,
                            'options' => array(
                                'none'        => esc_html__( 'No', 'grupi' ),
                                'order'   => esc_html__( 'Yes', 'grupi' ),
                            ),
                            'prefix_class' => 'ct-column-',
                            'default'      => 'none',
                        ),

                        array(
                            'name'    => 'row_scroll_fixed',
                            'label'   => esc_html__( 'Row Scroll - Column Fixed', 'grupi' ),
                            'type'    => \Elementor\Controls_Manager::SELECT,
                            'options' => array(
                                'none'        => esc_html__( 'No', 'grupi' ),
                                'fixed'   => esc_html__( 'Yes', 'grupi' ),
                            ),
                            'prefix_class' => 'ct-row-scroll-',
                            'default'      => 'none',
                        ),

                        array(
                            'name'    => 'gradient_color',
                            'label'   => esc_html__( 'Case Gradient Background Color', 'grupi' ),
                            'type'    => \Elementor\Controls_Manager::SELECT,
                            'options' => array(
                                'none'        => esc_html__( 'No', 'grupi' ),
                                'multi'   => esc_html__( 'Yes', 'grupi' ),
                            ),
                            'prefix_class' => 'ct-row-gradient--',
                            'default'      => 'none',
                        ),

                    ),
                ),
            ),
        );
    }
}