<?php
$default_settings = [
    'col_xl' => '4',
    'col_lg' => '4',
    'col_md' => '3',
    'col_sm' => '2',
    'col_xs' => '1',
    'content_list2' => '',
    'ct_animate' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);
$col_xl = 12 / intval($col_xl);
$col_lg = 12 / intval($col_lg);
$col_md = 12 / intval($col_md);
$col_sm = 12 / intval($col_sm);
$col_xs = 12 / intval($col_xs);
$grid_sizer = "col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
$item_class = "grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
?>
<?php if(isset($content_list2) && !empty($content_list2) && count($content_list2)): ?>
    <div class="ct-grid ct-testimonial-grid2">
        <div class="ct-grid-inner ct-grid-masonry row animate-time" data-gutter="7">
            <?php foreach ($content_list2 as $key => $value):
    			$title2 = isset($value['title2']) ? $value['title2'] : '';
                $description2 = isset($value['description2']) ? $value['description2'] : '';
                $icon2 = isset($value['icon2']) ? $value['icon2'] : '';
                ?>
                <div class="<?php echo esc_attr($item_class); ?>">
                    <div class="item--inner <?php echo esc_attr($ct_animate); ?>" data-wow-duration="1.2s">
                        <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve">
                            <g>
                                <path d="M125.887,235.044c4.497-34.094,34.635-64.954,89.763-91.846l9.927-4.843l-40.699-75.14l-9.188,4.657
                                    C59.111,126.967,0,210.482,0,316.1c0,36.442,11.568,67.916,34.385,93.55c23.137,25.991,51.215,39.17,83.46,39.17
                                    c28.973,0,53.541-10.317,73.021-30.668c19.353-20.22,29.166-45.335,29.166-74.649c0-27.7-9.912-52.386-29.461-73.372
                                    C173.329,251.62,151.603,239.845,125.887,235.044z M175.57,403.511c-15.546,16.241-34.428,24.135-57.725,24.135
                                    c-26.305,0-48.431-10.492-67.642-32.075c-19.534-21.944-29.03-47.939-29.03-79.472c0-48.407,13.631-92.11,40.512-129.893
                                    c25.649-36.049,64.119-67.876,114.44-94.7l20.389,37.642c-61.32,32.134-92.389,70.762-92.389,114.924v9.456l9.395,1.064
                                    c25.308,2.865,45.441,12.668,61.558,29.97c16.001,17.178,23.78,36.459,23.78,58.94C198.859,367.51,191.24,387.138,175.57,403.511z
                                    "/>
                            </g>
                            <g>
                                <path d="M413.206,235.075c4.443-34.122,34.333-64.998,89.019-91.893l9.775-4.807l-39.688-75.194l-9.279,4.682
                                    C345.921,126.955,286.541,210.474,286.541,316.1c0,36.465,11.716,67.956,34.821,93.597c23.393,25.959,51.587,39.122,83.806,39.122
                                    c29.009,0,53.464-10.337,72.685-30.725c19.056-20.212,28.719-45.308,28.719-74.592c0-27.701-9.912-52.387-29.459-73.372
                                    C459.906,251.659,438.442,239.894,413.206,235.075z M462.449,403.569c-15.277,16.202-34.012,24.078-57.281,24.078
                                    c-26.331,0-48.599-10.507-68.077-32.123c-19.769-21.938-29.378-47.917-29.378-79.424c0-48.399,13.693-92.095,40.693-129.874
                                    c25.763-36.041,64.399-67.863,114.934-94.684l19.836,37.584c-60.878,32.145-91.725,70.781-91.725,114.947v9.435l9.371,1.082
                                    c24.788,2.861,44.674,12.665,60.799,29.973c16.001,17.177,23.778,36.456,23.778,58.94
                                    C485.4,367.541,477.892,387.19,462.449,403.569z"/>
                            </g>
                        </svg>
                        <div class="item--description">
                            <?php echo ct_print_html($description2); ?>
                            <?php if(!empty($icon2['id'])) { 
                                $img = ct_get_image_by_size( array(
                                    'attach_id'  => $icon2['id'],
                                    'thumb_size' => 'full',
                                ));
                                $thumbnail = $img['thumbnail']; 
                                echo wp_kses_post($thumbnail); 
                            } ?>        
                        </div>
                        <div class="item--title">    
                            <?php echo esc_attr($title2); ?>
                        </div>
                   </div>
                </div>
            <?php endforeach; ?>
            <div class="grid-sizer <?php echo esc_attr($grid_sizer); ?>"></div>
        </div>
    </div>
<?php endif; ?>
