<?php
$widget->add_render_attribute( 'inner', [
    'class' => 'ct-carousel-inner',
] );

$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');

$arrows = $widget->get_setting('arrows');
$dots = $widget->get_setting('dots');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay', '');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite');
$speed = $widget->get_setting('speed', '500');
if (is_rtl()) {
    $carousel_dir = 'true';
} else {
    $carousel_dir = 'false';
}
$widget->add_render_attribute( 'carousel', [
    'class' => 'ct-slick-carousel slick-shadow',
    'data-arrows' => $arrows,
    'data-dots' => $dots,
    'data-pauseOnHover' => $pause_on_hover,
    'data-autoplay' => $autoplay,
    'data-autoplaySpeed' => $autoplay_speed,
    'data-infinite' => $infinite,
    'data-speed' => $speed,
    'data-colxs' => 1,
    'data-colsm' => 1,
    'data-colmd' => 1,
    'data-collg' => 1,
    'data-colxl' => 1,
    'data-dir' => $carousel_dir,
    'data-slidesToScroll' => $slides_to_scroll,
] );
$html_id = ct_get_element_id($settings);
?>
<?php if(isset($settings['testimonial']) && !empty($settings['testimonial']) && count($settings['testimonial'])): ?>
    <div class="ct-testimonial ct-testimonial-carousel3 ct-slick-slider ct-slick-arrow-style2 ct-slick-<?php echo esc_attr($settings['rows']); ?>-rows" <?php if($settings['drap']) : ?>data-cursor-label="<?php echo esc_html('DRAG', 'grupi'); ?>"<?php endif; ?>>
        <div <?php ct_print_html($widget->get_render_attribute_string( 'inner' )); ?>>
            <div <?php ct_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <?php 
                $counter = 0;
                foreach ($settings['testimonial'] as $key => $value): 
                    $title = isset($value['title']) ? $value['title'] : '';
                    $position = isset($value['position']) ? $value['position'] : '';
                    $description = isset($value['description']) ? $value['description'] : '';
                    $image = isset($value['image']) ? $value['image'] : '';
                    $item_color_main = isset($value['item_color_main']) ? $value['item_color_main'] : '';
                    $item_color_gradient = isset($value['item_color_gradient']) ? $value['item_color_gradient'] : '';
                    $counter++;
                    if($settings['rows'] == 1){
                        echo '<div class="carousel-item-wrap">';
                    }else{
                        if($counter % $settings['rows'] == 1){
                            echo '<div class="carousel-item-wrap">';
                        }
                    } ?>
                    <div id="<?php echo esc_attr($html_id.$key); ?>" class="item--inner <?php echo esc_attr($settings['ct_animate']); ?>" data-wow-duration="1.2s">
                        <div class="ct-inline-css"  data-css="
                            <?php if( !empty($item_color_main) && !empty($item_color_gradient) ) : ?>
                                .ct-testimonial-carousel3 #<?php echo esc_attr($html_id.$key); ?> .item--image::before  {
                                    background-image: -webkit-linear-gradient(135deg, <?php echo esc_attr($item_color_main); ?>, <?php echo esc_attr($item_color_gradient); ?>)!important;
                                    background-image: -moz-linear-gradient(135deg, <?php echo esc_attr($item_color_main); ?>, <?php echo esc_attr($item_color_gradient); ?>)!important;
                                    background-image: -ms-linear-gradient(135deg, <?php echo esc_attr($item_color_main); ?>, <?php echo esc_attr($item_color_gradient); ?>)!important;
                                    background-image: -o-linear-gradient(135deg, <?php echo esc_attr($item_color_main); ?>, <?php echo esc_attr($item_color_gradient); ?>)!important;
                                    background-image: linear-gradient(135deg, <?php echo esc_attr($item_color_main); ?>, <?php echo esc_attr($item_color_gradient); ?>)!important;
                                    filter: progid:DXImageTransform.Microsoft.gradient(startColorStr='<?php echo esc_attr($item_color_main); ?>', endColorStr='<?php echo esc_attr($item_color_gradient); ?>')!important;
                                    background-color: transparent !important;
                                }
                                .ct-testimonial-carousel3 #<?php echo esc_attr($html_id.$key); ?>.item--inner:before {
                                    box-shadow: 0 15px 45px <?php echo grupi_hex_to_rgba( $item_color_main, 0.22 ) ?>;
                                    -webkit-box-shadow: 0 15px 45px <?php echo grupi_hex_to_rgba( $item_color_main, 0.22 ) ?>;
                                }
                            <?php endif; ?>">
                        </div>
                        <div class="item--holder">
                            <div class="item--meta">
                                <?php if(!empty($image['id'])) { 
                                    $img = ct_get_image_by_size( array(
                                        'attach_id'  => $image['id'],
                                        'thumb_size' => '128x128',
                                    ));
                                    $thumbnail = $img['thumbnail']; 
                                    ?>
                                    <div class="item--image">
                                        <?php echo wp_kses_post($thumbnail); ?>

                                    </div>
                                <?php } ?>
                                <h4 class="item--title h3-title">    
                                    <?php echo esc_attr($title); ?>
                                </h4>
                                <div class="item--position"><?php echo esc_attr($position); ?></div>
                            </div>
                            <div class="item--description h3-desc">
                                <?php echo ct_print_html($description); ?>
                                <div class="item--star">
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                </div>        
                            </div>
                        </div>
                   </div>
                <?php if($settings['rows'] == 1){
                    echo '</div>';
                } else {
                    if($counter % $settings['rows'] == 0){
                        echo '</div>';
                    }
                } ?>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
<?php endif; ?>