<?php
$html_id = ct_get_element_id($settings);
$wg_subtitle = $widget->get_setting('wg_subtitle');
$wg_title_l3 = $widget->get_setting('wg_title_l3');
$wg_description = $widget->get_setting('wg_description');
$wg_btn_text = $widget->get_setting('wg_btn_text');
$wg_btn_link = $widget->get_setting('wg_btn_link');
$box_color_main = $widget->get_setting('box_color_main');
$box_color_gradient = $widget->get_setting('box_color_gradient');
$title_active_color_main = $widget->get_setting('title_active_color_main');
$title_active_color_gradient = $widget->get_setting('title_active_color_gradient');

$active_tab = $widget->get_setting('active_tab', 1);
$tabs = $widget->get_setting('tabs', '');
$tabs_title = [];
$tabs_content = [];
$is_new = \Elementor\Icons_Manager::is_migration_allowed();
foreach ($tabs as $key => $tab){
    $title_key = $widget->get_repeater_setting_key( 'tab_title', 'tabs', $key );
    $content_key = $widget->get_repeater_setting_key( 'tab_content', 'tabs', $key );

    $tabs_title[$title_key] = $tab['tab_title'];
    $tabs_content[$content_key] = '';
    if($tab['content_type'] == 'template'){
        if(!empty($tab['tab_content_template'])){
            $content = \Elementor\Plugin::$instance->frontend->get_builder_content( $tab['tab_content_template'] );
            $tabs_content[$content_key] = $content;
        }
    }
    $form_class = '';

    $widget->add_render_attribute( $title_key, [
        'class' => [ 'ct-tab-title' ],
        'data-target' => '#' . $html_id.'-'.$tab['_id'],
    ] );

    $widget->add_inline_editing_attributes( $title_key, 'basic' );
    $widget->add_render_attribute( $content_key, [
        'class' => [ 'ct-tab-content', $form_class ],
        'id' => $html_id.'-'.$tab['_id'],
    ] );
    if($tab['content_type'] == 'text_editor'){
        $widget->add_inline_editing_attributes( $content_key, 'advanced' );
    }

    if($active_tab == $key + 1){
        $widget->add_render_attribute( $content_key, 'style', 'display:block;');
        $widget->add_render_attribute( $title_key, 'class', 'active');
    }
}
if ( ! empty( $wg_btn_link['url'] ) ) {
    $widget->add_render_attribute( 'button', 'href', $wg_btn_link['url'] );

    if ( $wg_btn_link['is_external'] ) {
        $widget->add_render_attribute( 'button', 'target', '_blank' );
    }

    if ( $wg_btn_link['nofollow'] ) {
        $widget->add_render_attribute( 'button', 'rel', 'nofollow' );
    }
}
?>
<div id="<?php echo esc_attr($html_id); ?>" class="ct-tabs ct-tabs3 <?php echo esc_attr($settings['ct_animate']); ?> content-type-<?php echo esc_attr($tab['content_type']); ?>" data-wow-delay="<?php echo esc_attr($settings['ct_animate_delay']); ?>ms">
    <div class="ct-inline-css"  data-css="
        <?php if( !empty($box_color_main) && !empty($box_color_gradient) ) : ?>
            #<?php echo esc_attr($html_id) ?>.ct-tabs3 .ct-heading .item--sub-title.style-button span:before {
                background-image: -webkit-linear-gradient(135deg, <?php echo esc_attr($settings['box_color_main']); ?>, <?php echo esc_attr($settings['box_color_gradient']); ?>)!important;
                background-image: -moz-linear-gradient(135deg, <?php echo esc_attr($settings['box_color_main']); ?>, <?php echo esc_attr($settings['box_color_gradient']); ?>)!important;
                background-image: -ms-linear-gradient(135deg, <?php echo esc_attr($settings['box_color_main']); ?>, <?php echo esc_attr($settings['box_color_gradient']); ?>)!important;
                background-image: -o-linear-gradient(135deg, <?php echo esc_attr($settings['box_color_main']); ?>, <?php echo esc_attr($settings['box_color_gradient']); ?>)!important;
                background-image: linear-gradient(135deg, <?php echo esc_attr($settings['box_color_main']); ?>, <?php echo esc_attr($settings['box_color_gradient']); ?>)!important;
                filter: progid:DXImageTransform.Microsoft.gradient(startColorStr='<?php echo esc_attr($settings['box_color_main']); ?>', endColorStr='<?php echo esc_attr($settings['box_color_gradient']); ?>')!important;
                background-color: transparent !important;
            }
        <?php endif; ?>
        <?php if( !empty($title_active_color_main) && !empty($title_active_color_gradient) ) : ?>
            #<?php echo esc_attr($html_id) ?>.ct-tabs3 .ct-tabs-title .ct-tab-title:before,
            #<?php echo esc_attr($html_id) ?>.ct-tabs3 .ct-tabs-title .ct-tab-title.active,
            #<?php echo esc_attr($html_id) ?>.ct-tabs3 .ct-tabs-title .ct-tab-title:hover {
                background-image: -webkit-linear-gradient(135deg, <?php echo esc_attr($settings['title_active_color_main']); ?>, <?php echo esc_attr($settings['title_active_color_gradient']); ?>)!important;
                background-image: -moz-linear-gradient(135deg, <?php echo esc_attr($settings['title_active_color_main']); ?>, <?php echo esc_attr($settings['title_active_color_gradient']); ?>)!important;
                background-image: -ms-linear-gradient(135deg, <?php echo esc_attr($settings['title_active_color_main']); ?>, <?php echo esc_attr($settings['title_active_color_gradient']); ?>)!important;
                background-image: -o-linear-gradient(135deg, <?php echo esc_attr($settings['title_active_color_main']); ?>, <?php echo esc_attr($settings['title_active_color_gradient']); ?>)!important;
                background-image: linear-gradient(135deg, <?php echo esc_attr($settings['title_active_color_main']); ?>, <?php echo esc_attr($settings['title_active_color_gradient']); ?>)!important;
                filter: progid:DXImageTransform.Microsoft.gradient(startColorStr='<?php echo esc_attr($settings['title_active_color_main']); ?>', endColorStr='<?php echo esc_attr($settings['title_active_color_gradient']); ?>')!important;
                background-color: transparent !important;
            }
        <?php endif; ?>
        <?php if( !empty($title_active_color_gradient) ) : ?>
            #<?php echo esc_attr($html_id) ?>.ct-tabs3 .ct-tab-button a:hover, #<?php echo esc_attr($html_id) ?>.ct-tabs3 .ct-tab-button a:focus {
                background-color: <?php echo esc_attr($title_active_color_gradient); ?>;
            }
        <?php endif; ?>
        ">
    </div>
    <div class="ct-tabs--main">
        <div class="ct-tabs-title">
            <div class="ct-heading item-st-default">
                <?php if(!empty($wg_subtitle)) : ?>
                    <div class="item--sub-title style-button">
                        <span><?php echo esc_attr($wg_subtitle); ?></span>
                    </div>
                <?php endif; ?>
                <?php if(!empty($wg_title_l3)) : ?>
                    <h4 class="item--title st-default h3-title">
                        <span><?php echo esc_attr($wg_title_l3); ?></span>
                    </h4>
                <?php endif; ?>
                <?php if(!empty($wg_description)) : ?>
                    <div class="item--description h3-desc">
                        <span><?php echo esc_attr($wg_description); ?></span>
                    </div>
                <?php endif; ?>
            </div>

            <div class="ct-tabs-title-inner">
                <?php foreach ($tabs as $key => $tab) : 
                    $icon_key = $widget->get_repeater_setting_key( 'ct_icon', 'icons', $key );
                    $has_icon = ! empty( $tab['ct_icon'] );
                    $widget->add_render_attribute( $icon_key, [
                        'class' => $tab['ct_icon'],
                        'aria-hidden' => 'true',
                    ] );
                    ?>
                    <span class="ct-tab-title h3-title <?php if($active_tab == $key + 1) { echo 'active'; } ?>" data-target="#<?php echo esc_attr($html_id.'-'.$tab['_id']); ?>">
                        <?php
                            if($is_new):
                                \Elementor\Icons_Manager::render_icon( $tab['ct_icon'], [ 'aria-hidden' => 'true' ] );
                        ?>
                        <?php else: ?>
                            <i <?php ct_print_html($widget->get_render_attribute_string( $icon_key )); ?>></i>
                        <?php endif; ?>
                        <?php echo ct_print_html($tab['tab_title']); ?>
                    </span>
                <?php endforeach; ?>
            </div>

            <?php if(!empty($wg_btn_text)) : ?>
                <div class="ct-tab-button">
                    <a class="btn btn-default-s" <?php ct_print_html($widget->get_render_attribute_string( 'button' )); ?>><?php echo esc_attr($wg_btn_text); ?></a>
                </div>
            <?php endif;?>
        </div>

        <div class="ct-tabs-content">
            <?php foreach ($tabs_content as $content_key => $tab_content): ?>
                <div <?php ct_print_html($widget->get_render_attribute_string( $content_key )); ?>><?php ct_print_html($tab_content); ?></div>
            <?php endforeach; ?>
        </div>
    </div>
</div>