<?php
$default_settings = [
    'text' => '',
    'bg_color' => '',
    'bg_color_gradient' => '',
    'ct_animate' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);

if ( ! empty( $link['url'] ) ) {
    $widget->add_render_attribute( 'link', 'href', $link['url'] );

    if ( $link['is_external'] ) {
        $widget->add_render_attribute( 'link', 'target', '_blank' );
    }

    if ( $link['nofollow'] ) {
        $widget->add_render_attribute( 'link', 'rel', 'nofollow' );
    }
}

$is_new = \Elementor\Icons_Manager::is_migration_allowed();
$html_id = ct_get_element_id($settings);
?>
<div id="<?php echo esc_attr($html_id); ?>" class="ct-sticky1 <?php echo esc_attr($ct_animate); ?>">
    <div class="ct-inline-css"  data-css="
        <?php if( !empty($bg_color) && !empty($bg_color_gradient) ) : ?>
            #<?php echo esc_attr($html_id) ?>.ct-sticky1 {
                background-image: -webkit-gradient(linear, left top, right top, from(<?php echo esc_attr($bg_color_gradient); ?>), to(<?php echo esc_attr($bg_color); ?>)) !important;
                background-image: -webkit-linear-gradient(left, <?php echo esc_attr($bg_color_gradient); ?>, <?php echo esc_attr($bg_color); ?>) !important;
                background-image: -moz-linear-gradient(left, <?php echo esc_attr($bg_color_gradient); ?>, <?php echo esc_attr($bg_color); ?>) !important;
                background-image: -ms-linear-gradient(left, <?php echo esc_attr($bg_color_gradient); ?>, <?php echo esc_attr($bg_color); ?>) !important;
                background-image: -o-linear-gradient(left, <?php echo esc_attr($bg_color_gradient); ?>, <?php echo esc_attr($bg_color); ?>) !important;
                background-image: linear-gradient(left, <?php echo esc_attr($bg_color_gradient); ?>, <?php echo esc_attr($bg_color); ?>) !important;
                filter: progid:DXImageTransform.Microsoft.gradient(startColorStr='<?php echo esc_attr($bg_color_gradient); ?>', endColorStr='<?php echo esc_attr($bg_color); ?>') !important;
                background-color: transparent !important;

            }
            #<?php echo esc_attr($html_id) ?>.ct-sticky1:before {
                border-color: <?php echo esc_attr($bg_color_gradient); ?> <?php echo esc_attr($bg_color_gradient); ?> transparent transparent  !important;
            }
            #<?php echo esc_attr($html_id) ?>.ct-sticky1:after {
                border-color: transparent <?php echo esc_attr($bg_color_gradient); ?> <?php echo esc_attr($bg_color_gradient); ?> transparent !important;
            }
        <?php endif; ?>">
    </div>

	<div class="ct-sticky-inner">
		<?php echo esc_attr($text); ?>
	</div>
</div>