<?php
$default_settings = [
    'icons_l2' => '',
    'wg_label' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);
$has_icon = ! empty( $settings['ct_icon_l2'] );
if ( $has_icon ) {
    $widget->add_render_attribute( 'i', 'class', $settings['ct_icon_l2'] );
    $widget->add_render_attribute( 'i', 'aria-hidden', 'true' );
}
$is_new = \Elementor\Icons_Manager::is_migration_allowed();
$html_id = ct_get_element_id($settings);
?>
<?php if(isset($icons_l2) && !empty($icons_l2) && count($icons_l2)): ?>
    <div class="ct-social-icon2">
        <div class="ct-social-box"><i class="flaticon-link"></i></div>
        <div class="ct-social-label"><?php echo esc_attr($wg_label); ?></div>
        <div class="ct-social-icon-list">
            <?php foreach ($settings['icons_l2'] as $key => $value):
                $box_bg_color = isset($value['box_bg_color']) ? $value['box_bg_color'] : '';
                $icon_label = isset($value['icon_label']) ? $value['icon_label'] : '';
                $icon_key = $widget->get_repeater_setting_key( 'ct_icon_l2', 'icons_l2', $key );
                $has_icon = ! empty( $value['ct_icon_l2']['value'] );
                $widget->add_render_attribute( $icon_key, [
                    'class' => $value['ct_icon_l2'],
                    'aria-hidden' => 'true',
                ] );

                $link_key = $widget->get_repeater_setting_key( 'title', 'value', $key );
                if ( ! empty( $value['icon_link_l2']['url'] ) ) {
                    $widget->add_render_attribute( $link_key, 'href', $value['icon_link_l2']['url'] );

                    if ( $value['icon_link_l2']['is_external'] ) {
                        $widget->add_render_attribute( $link_key, 'target', '_blank' );
                    }

                    if ( $value['icon_link_l2']['nofollow'] ) {
                        $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                    }
                }
                $link_attributes = $widget->get_render_attribute_string( $link_key ); ?>
                <?php if ( $has_icon ) : ?>
                    <a <?php echo implode( ' ', [ $link_attributes ] ); ?>>
                        <?php
                            if($is_new):
                                \Elementor\Icons_Manager::render_icon( $value['ct_icon_l2'], [ 'aria-hidden' => 'true' ] );
                        ?>
                        <?php else: ?>
                            <i <?php ct_print_html($widget->get_render_attribute_string( $icon_key )); ?>></i>
                        <?php endif; ?>
                        <span><?php echo esc_attr($icon_label); ?></span>
                    </a>
                <?php endif; ?>
            <?php endforeach; ?>
        </div>
    </div>
<?php endif; ?>