<?php

$html_id = ct_get_element_id($settings);
$source = $widget->get_setting('source', '');
$orderby = $widget->get_setting('orderby', 'date');
$order = $widget->get_setting('order', 'desc');
$limit = $widget->get_setting('limit', 6);
$post_ids = $widget->get_setting('post_ids', '');
extract(ct_get_posts_of_grid('service', [
    'source' => $source,
    'orderby' => $orderby,
    'order' => $order,
    'limit' => $limit,
    'post_ids' => $post_ids,
]));

$widget->add_render_attribute( 'inner', [
    'class' => 'ct-carousel-inner',
] );

$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');

$show_title = $widget->get_setting('show_title');
$show_button = $widget->get_setting('show_button');
$img_size = $widget->get_setting('img_size');

$arrows = $widget->get_setting('arrows');
$dots = $widget->get_setting('dots');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite');
$speed = $widget->get_setting('speed', '500');
if (is_rtl()) {
    $carousel_dir = 'true';
} else {
    $carousel_dir = 'false';
}
$widget->add_render_attribute( 'carousel', [
    'class' => 'ct-slick-carousel',
    'data-arrows' => $arrows,
    'data-dots' => $dots,
    'data-pauseOnHover' => $pause_on_hover,
    'data-autoplay' => $autoplay,
    'data-autoplaySpeed' => $autoplay_speed,
    'data-infinite' => $infinite,
    'data-speed' => $speed,
    'data-colxs' => $col_xs,
    'data-colsm' => $col_sm,
    'data-colmd' => $col_md,
    'data-collg' => $col_lg,
    'data-colxl' => $col_xl,
    'data-dir' => $carousel_dir,
    'data-slidesToScroll' => $slides_to_scroll,
] );
if (is_array($posts)): ?>
    <div id="<?php echo esc_attr($html_id) ?>" class="ct-service-carousel1 ct-slick-slider dots-<?php echo esc_attr($settings['dots_position']); ?>">
        <div <?php ct_print_html($widget->get_render_attribute_string( 'inner' )); ?>>
            <div <?php ct_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
            <?php
                if(!empty($img_size)) {
                    $images_size = $img_size;
                } else {
                    $images_size = '370x340';
                }
                foreach ($posts as $post):
                $icon_type = get_post_meta($post->ID, 'icon_type', true);
                $service_icon = get_post_meta($post->ID, 'service_icon', true);
                $img_id = get_post_thumbnail_id($post->ID);
                $img = grupi_get_image_by_size( array(
                    'attach_id'  => $img_id,
                    'thumb_size' => $images_size,
                    'class' => 'no-lazyload',
                ));
                $thumbnail = $img['thumbnail'];
                $thumbnail_url = $img['thumbnail_url'];
                $service_feature = get_post_meta($post->ID, 'service_feature', true);
                $result_feature = count($service_feature);
                $service_custom_link = get_post_meta($post->ID, 'service_custom_link', true);
                $service_icon_img = get_post_meta($post->ID, 'service_icon_img', true);
                if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): ?>
                    <div class="carousel-item slick-slide">
                        <div class="grid-item-inner <?php echo esc_attr($settings['ct_animate']); ?>" data-wow-duration="1.2s"> 
                            <?php if($icon_type == 'icon' && !empty($service_icon)) : ?>
                                <div class="item--icon-abs"><i class="<?php echo esc_attr($service_icon); ?>"></i></div>
                            <?php endif; ?>
                            <div class="item--featured bg-image" style="background-image: url(<?php echo esc_url($thumbnail_url); ?>);"></div>
                            <div class="item--holder">
                                <?php if($icon_type == 'icon' && !empty($service_icon)) : ?>
                                    <div class="item--icon"><i class="<?php echo esc_attr($service_icon); ?>"></i></div>
                                <?php endif; ?>
                                <?php if($icon_type == 'image' && !empty($service_icon_img)) : 
                                    $icon_img = ct_get_image_by_size( array(
                                        'attach_id'  => $service_icon_img['id'],
                                        'thumb_size' => $img_size,
                                    ));
                                    $icon_thumbnail = $icon_img['thumbnail'];
                                    ?>
                                    <div class="item--icon">
                                        <?php echo wp_kses_post($icon_thumbnail); ?>
                                    </div>
                                <?php endif; ?>
                                <?php if($show_title == 'true'): ?>
                                    <h3 class="item--title">
                                        <?php if($show_button == 'true') : ?><a href="<?php if(!empty($service_custom_link)) { echo esc_url($service_custom_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>"><?php endif; ?>
                                            <?php echo esc_attr(get_the_title($post->ID)); ?>
                                        <?php if($show_button == 'true') : ?></a><?php endif; ?>
                                    </h3>
                                <?php endif; ?>
                                <?php if (!empty($service_feature)) : ?>
                                    <ul class="item--feature">
                                        <?php for($i=0; $i<$result_feature; $i++) { ?>
                                            <li><?php echo isset($service_feature[$i])?esc_html( $service_feature[$i] ):''; ?></li>
                                        <?php } ?>
                                    </ul>
                                <?php endif; ?>
                            </div>
                            <?php if($show_button == 'true') : ?>
                                <div class="item-readmore">
                                    <a href="<?php if(!empty($service_custom_link)) { echo esc_url($service_custom_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>"><i class="flaticon-next"></i></a>
                                </div>
                            <?php endif; ?>
                            <div class="item--line"></div>
                        </div>
                    </div>
                <?php endif; ?>
            <?php endforeach; ?>
            </div>
        </div>
    </div>
<?php endif; ?>