<?php
$default_settings = [
    'pix_circles' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);
if(isset($pix_circles) && !empty($pix_circles) && count($pix_circles)): ?>
    <div class="ct-pix-circles">
        <?php foreach ($pix_circles as $key => $value):
            $title = isset($value['title']) ? $value['title'] : '';
            $image = isset($value['image']) ? $value['image'] : '';
            $link = isset($value['link']) ? $value['link'] : '';
            $img = ct_get_image_by_size( array(
                'attach_id'  => $image['id'],
                'thumb_size' => '150x150',
                'class' => 'no-lazyload',
            ));
            $thumbnail = $img['thumbnail'];
            $link_key = $widget->get_repeater_setting_key( 'title', 'value', $key );
            if ( ! empty( $link['url'] ) ) {
                $widget->add_render_attribute( $link_key, 'href', $link['url'] );

                if ( $link['is_external'] ) {
                    $widget->add_render_attribute( $link_key, 'target', '_blank' );
                }

                if ( $link['nofollow'] ) {
                    $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                }
            }
            $link_attributes = $widget->get_render_attribute_string( $link_key );
            ?>
            <div class="ct-pix-circle--item">
                <?php if(!empty($image)) { ?>
                    <div class="item--image">
                        <?php if ( ! empty( $link['url'] ) ) { ?><a <?php echo implode( ' ', [ $link_attributes ] ); ?>><?php } ?><?php echo wp_kses_post($thumbnail); ?><?php if ( ! empty( $link['url'] ) ) { ?></a><?php } ?>
                        <div class="item--title">    
                            <?php if ( ! empty( $link['url'] ) ) { ?><a <?php echo implode( ' ', [ $link_attributes ] ); ?>><?php } ?><?php echo ct_print_html($title); ?><?php if ( ! empty( $link['url'] ) ) { ?></a><?php } ?>
                        </div>
                    </div>
                <?php } ?>
           </div>
        <?php endforeach; ?>
    </div>
<?php endif; ?>
