<?php
$default_settings = [
    'title' => '',
    'title_tag' => 'h3',
    'style' => 'st-default',
    'sub_title' => '',
    'sub_title_style' => '',
    'text_align' => '',
    'ct_animate' => '',
    'ct_animate_delay' => '',
    'text_below_shadow' => '',
    'ct_icon' => '',
    'highlight_color' => '',
    'highlight_color_gradient' => '',
    'sub_title_color' => '',
    'sub_title_color_gradient' => '',
    'icon_image' => '',
    'highlight_style' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings); 
$is_new = \Elementor\Icons_Manager::is_migration_allowed();
$html_id = ct_get_element_id($settings);

$editor_title = $widget->get_settings_for_display( 'title' );
$editor_title = $widget->parse_text_editor( $editor_title );
?>
<div id="<?php echo esc_attr($html_id); ?>" class="ct-heading h-align-<?php echo esc_attr($text_align); ?> item-<?php echo esc_attr($style); ?> highlight-<?php echo esc_attr($highlight_style); ?>">
    <div class="ct-inline-css"  data-css="
        <?php if( !empty($highlight_color) && !empty($highlight_color_gradient) ) : ?>
            #<?php echo esc_attr($html_id) ?>.ct-heading .ct-text-highlight {
                background-image: -webkit-gradient(linear, left top, left bottom, from(<?php echo esc_attr($highlight_color); ?>), to(<?php echo esc_attr($highlight_color_gradient); ?>));
                background-image: -webkit-linear-gradient(left, <?php echo esc_attr($highlight_color); ?>, <?php echo esc_attr($highlight_color_gradient); ?>);
                background-image: -moz-linear-gradient(left, <?php echo esc_attr($highlight_color); ?>, <?php echo esc_attr($highlight_color_gradient); ?>);
                background-image: -ms-linear-gradient(left, <?php echo esc_attr($highlight_color); ?>, <?php echo esc_attr($highlight_color_gradient); ?>);
                background-image: -o-linear-gradient(left, <?php echo esc_attr($highlight_color); ?>, <?php echo esc_attr($highlight_color_gradient); ?>);
                background-image: linear-gradient(left, <?php echo esc_attr($highlight_color); ?>, <?php echo esc_attr($highlight_color_gradient); ?>);
                filter: progid:DXImageTransform.Microsoft.gradient(startColorStr='<?php echo esc_attr($highlight_color); ?>', endColorStr='<?php echo esc_attr($highlight_color_gradient); ?>');
                background-color: transparent;
                background-clip: text;
                -o-background-clip: text;
                -ms-background-clip: text;
                -moz-background-clip: text;
                -webkit-background-clip: text;
                text-fill-color: transparent;
                -o-text-fill-color: transparent;
                -ms-text-fill-color: transparent;
                -moz-text-fill-color: transparent;
                -webkit-text-fill-color: transparent;
            }
        <?php endif; ?>
        <?php if( !empty($sub_title_color) && !empty($sub_title_color_gradient) ) : ?>
            #<?php echo esc_attr($html_id) ?>.ct-heading .item--sub-title span {
                background-image: -webkit-gradient(linear, left top, left bottom, from(<?php echo esc_attr($sub_title_color); ?>), to(<?php echo esc_attr($sub_title_color_gradient); ?>));
                background-image: -webkit-linear-gradient(left, <?php echo esc_attr($sub_title_color); ?>, <?php echo esc_attr($sub_title_color_gradient); ?>);
                background-image: -moz-linear-gradient(left, <?php echo esc_attr($sub_title_color); ?>, <?php echo esc_attr($sub_title_color_gradient); ?>);
                background-image: -ms-linear-gradient(left, <?php echo esc_attr($sub_title_color); ?>, <?php echo esc_attr($sub_title_color_gradient); ?>);
                background-image: -o-linear-gradient(left, <?php echo esc_attr($sub_title_color); ?>, <?php echo esc_attr($sub_title_color_gradient); ?>);
                background-image: linear-gradient(left, <?php echo esc_attr($sub_title_color); ?>, <?php echo esc_attr($sub_title_color_gradient); ?>);
                filter: progid:DXImageTransform.Microsoft.gradient(startColorStr='<?php echo esc_attr($sub_title_color); ?>', endColorStr='<?php echo esc_attr($sub_title_color_gradient); ?>');
                background-color: transparent;
                background-clip: text;
                -o-background-clip: text;
                -ms-background-clip: text;
                -moz-background-clip: text;
                -webkit-background-clip: text;
                text-fill-color: transparent;
                -o-text-fill-color: transparent;
                -ms-text-fill-color: transparent;
                -moz-text-fill-color: transparent;
                -webkit-text-fill-color: transparent;
            }
        <?php endif; ?>
        <?php if( !empty($settings['box_color_main']) && !empty($settings['box_color_gradient']) ) : ?>
            #<?php echo esc_attr($html_id) ?>.ct-heading .item--sub-title.style-button span:before {
                background-image: -webkit-linear-gradient(135deg, <?php echo esc_attr($settings['box_color_main']); ?>, <?php echo esc_attr($settings['box_color_gradient']); ?>)!important;
                background-image: -moz-linear-gradient(135deg, <?php echo esc_attr($settings['box_color_main']); ?>, <?php echo esc_attr($settings['box_color_gradient']); ?>)!important;
                background-image: -ms-linear-gradient(135deg, <?php echo esc_attr($settings['box_color_main']); ?>, <?php echo esc_attr($settings['box_color_gradient']); ?>)!important;
                background-image: -o-linear-gradient(135deg, <?php echo esc_attr($settings['box_color_main']); ?>, <?php echo esc_attr($settings['box_color_gradient']); ?>)!important;
                background-image: linear-gradient(135deg, <?php echo esc_attr($settings['box_color_main']); ?>, <?php echo esc_attr($settings['box_color_gradient']); ?>)!important;
                filter: progid:DXImageTransform.Microsoft.gradient(startColorStr='<?php echo esc_attr($settings['box_color_main']); ?>', endColorStr='<?php echo esc_attr($settings['box_color_gradient']); ?>')!important;
                background-color: transparent !important;
            }
        <?php endif; ?>">
    </div>

	<?php if(!empty($sub_title)) : ?>
		<div class="item--sub-title <?php echo esc_attr($sub_title_style); ?>">
            <span>
                <?php echo esc_attr($sub_title); ?>
            </span>
        </div>
	<?php endif; ?>
    <?php if($style == 'st-hexagon') : ?>
        <div class="ct-heading-hexagon-line">
            <div class="ct-heading-hexagon"></div>
        </div>
    <?php endif; ?>
    <?php if(!empty($text_below_shadow)) : ?>
        <div class="ct-heading-text-below">
            <?php echo esc_attr($text_below_shadow); ?>
        </div>
    <?php endif; ?>
    <<?php echo esc_attr($title_tag); ?> class="item--title case-animate-time <?php echo esc_attr($style); ?> <?php if($ct_animate != 'case-fade-in-up') { echo esc_attr($ct_animate); } ?>" data-wow-delay="<?php echo esc_attr($ct_animate_delay); ?>ms">
        <?php if($ct_animate == 'case-fade-in-up') {
            $arr_str = explode(' ', $title);
            foreach ($arr_str as $index => $value) {
                $arr_str[$index] = '<span class="slide-in-container"><span class="d-inline-block wow '.$ct_animate.'">' . $value . '</span></span>';
            }
            $str = implode(' ', $arr_str);
            echo wp_kses_post($str);
        } else {
            echo '<span>';
            echo wp_kses_post($editor_title);
            echo '</span>';
        } ?>
        <?php if(!empty($icon_image['id'])) { 
            $img_icon  = ct_get_image_by_size( array(
                'attach_id'  => $icon_image['id'],
                'thumb_size' => 'full',
            ) );
            $thumbnail_icon    = $img_icon['thumbnail'];
            ?>
            <span class="ct-heading-icon"><?php echo ct_print_html($thumbnail_icon); ?></span>
        <?php } ?>
    </<?php echo esc_attr($title_tag); ?>>
</div>

