<?php
$default_settings = [
    'date' => '2030/10/10',
];
$settings = array_merge($default_settings, $settings);
extract($settings); 
$month = esc_html__('Month', 'grupi');
$months = esc_html__('Months', 'grupi');
$day = esc_html__('Day', 'grupi');
$days = esc_html__('Days', 'grupi');
$hour = esc_html__('Hour', 'grupi');
$hours = esc_html__('Hours', 'grupi');
$minute = esc_html__('Minute', 'grupi');
$minutes = esc_html__('Minutes', 'grupi');
$second = esc_html__('Second', 'grupi');
$seconds = esc_html__('Seconds', 'grupi');
$gradient_color = grupi_get_opt( 'gradient_color' );
$gradient_color_form = '#f4a21a';
if ( !empty($gradient_color['from']) && isset($gradient_color['from']) ) {
    $gradient_color_form = $gradient_color['from'];
}
$gradient_color_to = '#ffde00';
if ( !empty($gradient_color['to']) && isset($gradient_color['to']) ) {
    $gradient_color_to = $gradient_color['to'];
}
?>
<div class="ct-countdown-wrap">
	<div class="ct-countdown ct-countdown-layout1 <?php echo esc_attr($settings['ct_animate']); ?>" 
		data-color-from="<?php echo esc_attr($gradient_color_form) ?>"
		data-color-to="<?php echo esc_attr($gradient_color_to) ?>"
		data-month="<?php echo esc_attr($month) ?>"
		data-months="<?php echo esc_attr($months) ?>"
		data-day="<?php echo esc_attr($day) ?>"
		data-days="<?php echo esc_attr($days) ?>"
		data-hour="<?php echo esc_attr($hour) ?>"
		data-hours="<?php echo esc_attr($hours) ?>"
		data-minute="<?php echo esc_attr($minute) ?>"
		data-minutes="<?php echo esc_attr($minutes) ?>"
		data-second="<?php echo esc_attr($second) ?>"
		data-seconds="<?php echo esc_attr($seconds) ?>" data-wow-delay="<?php echo esc_attr($settings['ct_animate_delay']); ?>ms">
		<div class="ct-countdown-inner" data-count-down="<?php echo esc_attr($date);?>"></div>
	</div>
</div>