<?php
$default_settings = [
    'banner_image' => '',
    'banner_title' => '',
    'banner_year' => '',
    'ct_animate' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);
$m_gradient_color1 = grupi_get_opt( 'm_gradient_color1', '#f9bd0e' );
$m_gradient_color2 = grupi_get_opt( 'm_gradient_color2', '#f9bd0e' );
$m_gradient_color3 = grupi_get_opt( 'm_gradient_color3', '#f9bd0e' );
$m_gradient_color4 = grupi_get_opt( 'm_gradient_color4', '#f9bd0e' );
$m_gradient_color5 = grupi_get_opt( 'm_gradient_color5', '#f9bd0e' );
if(!empty($banner_image['id'])) : 

	$img = ct_get_image_by_size( array(
		'attach_id'  => $banner_image['id'],
		'thumb_size' => 'full',
	));
	$thumbnail = $img['thumbnail'];

	?>
	<div class="ct-banner ct-banner3 <?php echo esc_attr($ct_animate); ?>">
		<div class="ct-banner-inner">
			<div class="ct-banner-image">
				<?php echo wp_kses_post($thumbnail); ?>
			</div>
			<div class="ct-banner-meta">
				<?php if(!empty($banner_title)) : ?>
					<div class="ct-banner-title ct-circle-type">
						<svg id="tutorial" data-name="tutorial" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 144.48 144.48">
							<path id="ct-banner-curve" d="M242.93,123A71.74,71.74,0,1,1,171.2,51.22,71.73,71.73,0,0,1,242.93,123Z" transform="translate(-98.96 -50.72)"/>
							<text fill="url(#ct-circle-text)">
						        <textPath href="#ct-banner-curve">
									<?php echo esc_attr($banner_title); ?>
								</textPath>
						    </text>
						    <defs>
								<linearGradient id="ct-circle-text" x1="0" x2="0" y1="0" y2="100%" gradientUnits="userSpaceOnUse" >
									<stop stop-color="<?php echo esc_attr($m_gradient_color1); ?>" offset="0%"/>
									<stop stop-color="<?php echo esc_attr($m_gradient_color2); ?>" offset="27%"/>
									<stop stop-color="<?php echo esc_attr($m_gradient_color3); ?>" offset="48%"/>
									<stop stop-color="<?php echo esc_attr($m_gradient_color4); ?>" offset="69%"/>
									<stop stop-color="<?php echo esc_attr($m_gradient_color5); ?>" offset="100%"/> 
								</linearGradient>
							</defs>
						</svg>
					</div>
				<?php endif; ?>
				<div class="ct-banner-year ct-counter-number-value" data-duration="2000" data-to-value="<?php echo esc_attr($banner_year); ?>" data-delimiter=""></div>
			</div>
		</div>
	</div>
<?php endif; ?>