<?php
ct_add_custom_widget(
    array(
        'name' => 'ct_sticky',
        'title' => esc_html__('Case Sticky', 'grupi'),
        'icon' => 'eicon-post',
        'categories' => array(Case_Theme_Core::CT_CATEGORY_NAME),
        'scripts' => [
            'ct-inline-css-js',
        ],
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_contact_info',
                    'label' => esc_html__('Content', 'grupi'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(

                        array(
                            'name' => 'text',
                            'label' => esc_html__('Text', 'grupi'),
                            'type' => \Elementor\Controls_Manager::TEXT,
                        ),
                        array(
                            'name' => 'text_color',
                            'label' => esc_html__('Text Color', 'grupi' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .ct-sticky1' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'bg_color',
                            'label' => esc_html__('Background Color Main', 'grupi' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .ct-sticky1' => 'background-color: {{VALUE}} !important; background-image: none !important;',
                                '{{WRAPPER}} .ct-sticky1:before' => 'border-color: {{VALUE}} {{VALUE}} transparent transparent',
                                '{{WRAPPER}} .ct-sticky1:after' => 'border-color: transparent {{VALUE}} {{VALUE}} transparent',
                            ],
                        ),
                        array(
                            'name' => 'bg_color_gradient',
                            'label' => esc_html__('Background Color Gradient', 'grupi' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                        ),
                        array(
                            'name' => 'left_position',
                            'label' => esc_html__('Left Position', 'grupi' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 5000,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .ct-sticky1' => 'left: {{SIZE}}{{UNIT}};',
                            ],
                        ),

                        array(
                            'name' => 'ct_animate',
                            'label' => esc_html__('Case Animate', 'grupi' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => grupi_animate(),
                            'default' => '',
                        ),
                    ),
                ),
            ),
        ),
    ),
    get_template_directory() . '/elementor/core/widgets/'
);