<?php

if ( class_exists( 'MPC_Plugins_Updater' ) ) {
	return;
}

class MPC_Plugins_Updater {
	public $slug;
	private $short_slug;
	private $plugin_data;
	private $plugin_file;
	private $plugin_update;
	private $update_urls = array();

	/*
	* Plugins Updater constructor function
	*
	* @param string $plugin_file absolute path tho plugin main file
	* @param string $short_slug original plugin directory name i.e.'responsive-flipbook'
	*
	*/
	function __construct( $plugin_file, $short_slug ) {
		if ( is_admin() ) {
			$this->plugin_file = $plugin_file;
			$this->slug        = plugin_basename( $this->plugin_file );

			$this->short_slug = $short_slug;

			if ( $this->short_slug === '' ) {
				return;
			}

			add_filter( 'pre_set_site_transient_update_plugins', array( $this, 'set_transient' ) );
			add_filter( 'plugins_api', array( $this, 'set_plugin_info' ), 1000, 3 );

			add_action( 'in_plugin_update_message-' . $this->slug, array( $this, 'purchase_code_notice' ), 10, 2 );
		}
	}

	private function init_plugin_data() {
		if ( empty( $this->plugin_data ) ) {

			$this->update_urls = array(
				'main' => 'https://products.mpcthemes.net/api/updates/' . $this->short_slug . '/update.json',
			);

			if ( function_exists( 'get_plugin_data' ) ) {
				$this->plugin_data = get_plugin_data( $this->plugin_file );
			}
		}
	}

	public function purchase_code_notice( $plugin_data, $plugin_update, $return = false ) {
		$options = json_decode( get_option( 'rfbwp_advanced_options' ), true );

		if ( isset( $options[ $this->short_slug . '_license' ] ) && strlen( $options[ $this->short_slug . '_license' ] ) === 36 ) {
			return '';
		}

		$notice = '<br/><strong>' . __( 'Automatic update is possible only with valid purchase code. Please include your purchase code at ', 'rfbwp' ) . '<a href="' . get_admin_url() . 'admin.php?page=rfbwp_cooperation_page_options">' . __( 'Flip Books -> License & Advanced Settings', 'rfbwp' ) . '.</a></strong>';

		if ( $return ) {
			return $notice;
		}

		echo $notice;
		return '';
	}

	public function get_update_info() {
		if ( $this->plugin_data['Plugin Slug'] !== $this->short_slug ) {
			$this->plugin_update = new WP_Error( 'plugins_api_failed', __( 'It seems like plugin directory name has been changed.' ), 'rfbwp' );
			return;
		}

		$http_args = array(
			'timeout' => 15,
		);

		$download_link = 'main';

		$request = wp_remote_get( $this->update_urls['main'], $http_args );

		if ( is_wp_error( $request ) ) {
			$res = new WP_Error( 'plugins_api_failed', __( 'An unexpected error occurred. Something may be wrong with WordPress.org or this server&#8217;s configuration. If you continue to have problems, please try the <a href="https://wordpress.org/support/">support forums</a>.' ), $request->get_error_message() );
		} else {
			$res = json_decode( wp_remote_retrieve_body( $request ) );

			if ( ! is_object( $res ) && ! is_array( $res ) ) {
				$res                 = new WP_Error( 'plugins_api_failed', __( 'An unexpected error occurred. Something may be wrong with WordPress.org or this server&#8217;s configuration. If you continue to have problems, please try the <a href="https://wordpress.org/support/">support forums</a>.' ), wp_remote_retrieve_body( $request ) );
				$this->plugin_update = $res;
				return;
			}

			$res->external = true;
			$res->sections = (array) $res->sections;
			$res->banners  = (array) $res->banners;

			$options = json_decode( get_option( 'rfbwp_advanced_options' ), true );

			if ( isset( $options[ $this->short_slug . '_license' ] ) && $options[ $this->short_slug . '_license' ] != '' ) {
				$res->download_link = str_replace( '/' . $this->short_slug . '/update.json', '/download.php', $this->update_urls[ $download_link ] );
				$res->download_link = add_query_arg(
					array(
						'key'     => $options[ $this->short_slug . '_license' ],
						'product' => $this->short_slug,
					),
					$res->download_link
				);
			} else {
				$res->download_link = 'not_authorized';
			}
		}

		$this->plugin_update = $res;
	}

	public function set_transient( $transient ) {

		if ( isset( $transient->response[ $this->slug ] ) ) {
			return $transient;
		}

		$this->init_plugin_data();
		$this->get_update_info();

		if ( isset( $this->plugin_update->version ) && isset( $this->slug ) && isset( $this->plugin_data['Version'] ) ) {
			$do_update = version_compare( $this->plugin_update->version, $this->plugin_data['Version'] );
		} else {
			return $transient;
		}

		if ( $do_update === 1 ) {
			$this->plugin_update->new_version    = $this->plugin_update->version;
			$this->plugin_update->version        = $this->plugin_data['Version'];
			$this->plugin_update->package        = $this->plugin_update->download_link;
			$this->plugin_update->upgrade_notice = $this->purchase_code_notice( null, null, true );

			$transient->response[ $this->slug ] = $this->plugin_update;
		}

		return $transient;
	}

	public function set_plugin_info( $res, $action, $args ) {
		$this->init_plugin_data();

		if ( $action !== 'plugin_information' || $args->slug !== $this->short_slug ) {
			return $res;
		}

		$this->get_update_info();

		if ( $this->plugin_update ) {
			$res = $this->plugin_update;
		}

		return $res;
	}
}
