<?php
/* PAGE MARKUP */
function rfbwp_display_pdf_wizard() {
	ob_start();
	?>
	<div id="rfbwp_pdf_wizard" class="rfbwp-pdf-wizard-wrap">

		<div id="rfbwp_error_box" class="rfbwp-error-box" data-error="">
			<div class="rfbwp-error-file rfbwp-error">
				<h3><?php esc_html_e( 'PDF file issue.', 'rfbwp-pdf' ); ?></h3>
				<p><?php esc_html_e( 'Selected file can\'t be read as PDF. Please select other file for convertion.', 'rfbwp-pdf' ); ?></p>
				<p><?php _e( 'Please <a href="#" class="rfbwp-restart">try again</a>. If the issue would repeat contact our support team :)', 'rfbwp-pdf' ); ?></p>
			</div>
			<div class="rfbwp-error-pages rfbwp-error">
				<h3><?php esc_html_e( 'PDF pages issue.', 'rfbwp-pdf' ); ?></h3>
				<p><?php esc_html_e( 'PDF have too few pages. It should have at least 3 pages.', 'rfbwp-pdf' ); ?></p>
				<p><?php _e( 'Please <a href="#" class="rfbwp-restart">try again</a>. If the issue would repeat contact our support team :)', 'rfbwp-pdf' ); ?></p>
			</div>
			<div class="rfbwp-error-import rfbwp-error">
				<h3><?php esc_html_e( 'Import issue.', 'rfbwp-pdf' ); ?></h3>
				<p><?php esc_html_e( 'We couldn\'t proceed with the import.', 'rfbwp-pdf' ); ?></p>
				<p><?php _e( 'Please <a href="#" class="rfbwp-restart">try again</a>. If the issue would repeat contact our support team :)', 'rfbwp-pdf' ); ?></p>
			</div>
			<div class="rfbwp-error-server rfbwp-error">
				<h3><?php esc_html_e( 'Server issue.', 'rfbwp-pdf' ); ?></h3>
				<p><?php esc_html_e( 'We couldn\'t save new book correctly.', 'rfbwp-pdf' ); ?></p>
				<p class="rfbwp-error-message"></p>
			</div>
		</div>

		<div id="rfbwp_step_options" class="rfbwp-step rfbwp-active">
			<h3><?php _e( 'Step 1: <em>Set Flipbook options</em>', 'rfbwp-pdf' ); ?></h3>
			<label for="rfbwp_name"><?php esc_html_e( 'Flipbook name:', 'rfbwp-pdf' ); ?></label>
			<input id="rfbwp_name" type="text" name="rfbwp_name" placeholder="<?php esc_html_e( 'Flipbook name', 'rfbwp-pdf' ); ?>">
		</div>

		<div id="rfbwp_step_pdf" class="rfbwp-step">
			<h3><?php _e( 'Step 2: <em>Select PDF</em>', 'rfbwp-pdf' ); ?></h3>
			<div class="rfbwp-link-wrap">
				<input id="rfbwp_pdf" type="file" name="files[]">
				<span id="rfbwp_pdf_overlay" class="rfbwp-file-name rfbwp-link" data-text="<?php esc_html_e( 'Click to select a file', 'rfbwp-pdf' ); ?>"><?php esc_html_e( 'Click to select a file', 'rfbwp-pdf' ); ?></span>
			</div>
		</div>

		<div id="rfbwp_step_convert" class="rfbwp-step">
			<h3><?php _e( 'Step 3: <em>Start conversion</em>', 'rfbwp-pdf' ); ?></h3>
			<a href="#" id="rfbwp_convert" class="rfbwp-link"><?php esc_html_e( 'Convert PDF', 'rfbwp-pdf' ); ?></a>
			<div id="rfbwp_converting" class="rfbwp-progress">
				<span><?php esc_html_e( 'Converting: ' ); ?></span>
				<span class="rfbwp-value">0%</span>
				<span class="rfbwp-time" data-text="<?php esc_html_e( '( calculating... )', 'rfbwp-pdf' ); ?>"><?php esc_html_e( '( calculating... )', 'rfbwp-pdf' ); ?></span>
				<span class="rfbwp-line"></span>
			</div>
		</div>

		<div class="rfbwp-converter">
			<canvas id="rfbwp_canvas"></canvas>
			<img id="rfbwp_image" src="">
		</div>

	</div>
	<?php
	return ob_get_clean();
}

/*----------------------------------------------------------------------------*\
	AJAX REQUESTS
\*----------------------------------------------------------------------------*/

/* Local importing single image */
add_action( 'wp_ajax_rfbwp_local_import_single_image', 'rfbwp_local_import_single_image' );
function rfbwp_local_import_single_image() {
	if ( ! isset( $_REQUEST[ 'image_sring' ] ) && ! isset( $_REQUEST[ 'image_index' ] ) && ! isset( $_REQUEST[ 'fb_name' ] ) )
		return;

	require_once( ABSPATH . 'wp-admin/includes/image.php' );

	$base = substr( $_REQUEST[ 'image_sring' ], 23 ); // strip "data:image/jpeg;base64,"

	$decoded = base64_decode( $base );

	$filename_path = $_REQUEST[ 'fb_name' ] . '_' . str_pad( $_REQUEST[ 'image_index' ], 3, '0', STR_PAD_LEFT ) . '.jpg';

	$uploaded_file  = wp_upload_bits( $filename_path, null, $decoded );
	$wp_upload_dir  = wp_upload_dir();
	$file_path      = $wp_upload_dir[ 'basedir' ] . str_replace( $wp_upload_dir[ 'baseurl' ], '', $uploaded_file[ 'url' ] );
	$parent_post_id = 0;
	$filetype       = wp_check_filetype( basename( $file_path ), null );
	$file_data      = array(
		'guid'           => $wp_upload_dir[ 'url' ] . '/' . basename( $file_path ),
		'post_mime_type' => $filetype[ 'type' ],
		'post_title'     => preg_replace( '/\.[^.]+$/', '', basename( $file_path ) ),
		'post_content'   => '',
		'post_status'    => 'inherit'
	);

	$file_id       = wp_insert_attachment( $file_data, $file_path, $parent_post_id );
	$file_metadata = wp_generate_attachment_metadata( $file_id, $file_path );
	wp_update_attachment_metadata( $file_id, $file_metadata );

	$file_info = array(
		'url'    => $uploaded_file[ 'url' ],
		'width'  => $file_metadata[ 'width' ],
		'height' => $file_metadata[ 'height' ]
	);

	wp_send_json_success( $file_info );
}

/* Creating new flipbook */
add_action( 'wp_ajax_rfbwp_create_new_flipbook', 'rfbwp_create_new_flipbook' );
function rfbwp_create_new_flipbook() {
	if ( ! isset( $_REQUEST[ 'flipbook' ] ) )
		return;

	$base_flipbook = array(
		'rfbwp_fb_force_open' => '0',
		'rfbwp_fb_border_size' => '0',
		'rfbwp_fb_border_color' => '',
		'rfbwp_fb_border_radius' => '0',
		'rfbwp_fb_outline' => '0',
		'rfbwp_fb_outline_color' => '',
		'rfbwp_fb_inner_shadows' => '1',
		'rfbwp_fb_edge_outline' => '0',
		'rfbwp_fb_edge_outline_color' => '',
		'rfbwp_fb_fs_color' => '#ededed',
		'rfbwp_fb_fs_opacity' => '95',
		'rfbwp_fb_fs_icon_color' => '1',
		'rfbwp_fb_toc_display_style' => '0',
		'rfbwp_fb_heading_font' => '0',
		'rfbwp_fb_heading_family' => 'default',
		'rfbwp_fb_heading_fontstyle' => 'regular',
		'rfbwp_fb_heading_size' => '24',
		'rfbwp_fb_heading_line' => '',
		'rfbwp_fb_heading_color' => '#2b2b2b',
		'rfbwp_fb_content_font' => '0',
		'rfbwp_fb_content_family' => 'default',
		'rfbwp_fb_content_fontstyle' => 'regular',
		'rfbwp_fb_content_size' => '24',
		'rfbwp_fb_content_line' => '',
		'rfbwp_fb_content_color' => '#2b2b2b',
		'rfbwp_fb_num_font' => '0',
		'rfbwp_fb_num_family' => 'default',
		'rfbwp_fb_num_fontstyle' => 'regular',
		'rfbwp_fb_num_size' => '24',
		'rfbwp_fb_num_line' => '',
		'rfbwp_fb_num_color' => '#2b2b2b',
		'rfbwp_fb_toc_font' => '0',
		'rfbwp_fb_toc_family' => 'default',
		'rfbwp_fb_toc_fontstyle' => 'regular',
		'rfbwp_fb_toc_size' => '24',
		'rfbwp_fb_toc_line' => '',
		'rfbwp_fb_toc_color' => '#2b2b2b',
		'rfbwp_fb_zoom_border_size' => '10',
		'rfbwp_fb_zoom_border_color' => '#ECECEC',
		'rfbwp_fb_zoom_border_radius' => '10',
		'rfbwp_fb_zoom_outline' => '1',
		'rfbwp_fb_zoom_outline_color' => '#D0D0D0',
		'rfbwp_fb_sa_thumb_cols' => '3',
		'rfbwp_fb_sa_thumb_border_size' => '1',
		'rfbwp_fb_sa_thumb_border_color' => '#878787',
		'rfbwp_fb_sa_vertical_padding' => '10',
		'rfbwp_fb_sa_horizontal_padding' => '10',
		'rfbwp_fb_sa_border_size' => '10',
		'rfbwp_fb_sa_border_color' => '#F6F6F6',
		'rfbwp_fb_sa_border_radius' => '10',
		'rfbwp_fb_sa_outline' => '1',
		'rfbwp_fb_sa_outline_color' => '#D6D6D6',
		'rfbwp_fb_nav_menu_type' => '0',
		'rfbwp_fb_nav_menu_position' => 'bottom',
		'rfbwp_fb_nav_stack' => '0',
		'rfbwp_fb_nav_text' => '0',
		'rfbwp_fb_nav_toc' => '1',
		'rfbwp_fb_nav_toc_order' => '1',
		'rfbwp_fb_nav_toc_index' => '2',
		'rfbwp_fb_nav_toc_icon' => 'fa fa-th-list',
		'rfbwp_fb_nav_zoom' => '1',
		'rfbwp_fb_nav_zoom_order' => '2',
		'rfbwp_fb_nav_zoom_icon' => 'fa fa-search-plus',
		'rfbwp_fb_nav_zoom_out_icon' => 'fa fa-search-minus',
		'rfbwp_fb_nav_ss' => '1',
		'rfbwp_fb_nav_ss_order' => '3',
		'rfbwp_fb_nav_ss_delay' => '2000',
		'rfbwp_fb_nav_sap_icon_next' => 'fa fa-chevron-down',
		'rfbwp_fb_nav_sap_icon_prev' => 'fa fa-chevron-up',
		'rfbwp_fb_nav_ss_icon' => 'fa fa-play',
		'rfbwp_fb_nav_ss_stop_icon' => 'fa fa-pause',
		'rfbwp_fb_nav_sap' => '1',
		'rfbwp_fb_nav_sap_order' => '4',
		'rfbwp_fb_nav_sap_icon' => 'fa fa-th',
		'rfbwp_fb_nav_sap_icon_close' => 'fa fa-times',
		'rfbwp_fb_nav_fs' => '1',
		'rfbwp_fb_nav_fs_order' => '5',
		'rfbwp_fb_nav_fs_icon' => 'fa fa-expand',
		'rfbwp_fb_nav_fs_close_icon' => 'fa fa-compress',
		'rfbwp_fb_nav_arrows' => '1',
		'rfbwp_fb_nav_arrows_toolbar' => '1',
		'rfbwp_fb_nav_prev_icon' => 'fa fa-chevron-left',
		'rfbwp_fb_nav_next_icon' => 'fa fa-chevron-right',
		'rfbwp_fb_nav_general' => '1',
		'rfbwp_fb_nav_general_v_padding' => '15',
		'rfbwp_fb_nav_general_h_padding' => '15',
		'rfbwp_fb_nav_general_margin' => '20',
		'rfbwp_fb_nav_general_fontsize' => '22',
		'rfbwp_fb_nav_general_bordersize' => '0',
		'rfbwp_fb_nav_general_shadow' => '0',
		'rfbwp_fb_nav_default' => '1',
		'rfbwp_fb_nav_default_color' => '#2b2b2b',
		'rfbwp_fb_nav_default_background' => '',
		'rfbwp_fb_nav_hover' => '1',
		'rfbwp_fb_nav_hover_color' => '#22b4d8',
		'rfbwp_fb_nav_hover_background' => '',
		'rfbwp_fb_nav_border_default' => '1',
		'rfbwp_fb_nav_border_color' => '',
		'rfbwp_fb_nav_border_radius' => '2',
		'rfbwp_fb_nav_border_hover' => '1',
		'rfbwp_fb_nav_border_hover_color' => '',
		'rfbwp_fb_nav_border_hover_radius' => '2',
		'rfbwp_fb_num' => '0',
		'rfbwp_fb_num_hide' => '1',
		'rfbwp_fb_num_style' => '0',
		'rfbwp_fb_num_background' => '',
		'rfbwp_fb_num_border' => '0',
		'rfbwp_fb_num_border_color' => '',
		'rfbwp_fb_num_border_size' => '2',
		'rfbwp_fb_num_border_radius' => '2',
		'rfbwp_fb_num_v_position' => 'top',
		'rfbwp_fb_num_h_position' => 'center',
		'rfbwp_fb_num_v_padding' => '12',
		'rfbwp_fb_num_h_padding' => '10',
		'rfbwp_fb_num_v_margin' => '12',
		'rfbwp_fb_num_h_margin' => '10',
		'rfbwp_fb_hc' => '',
		'rfbwp_fb_hc_fco' => '',
		'rfbwp_fb_hc_fci' => '',
		'rfbwp_fb_hc_fcc' => '',
		'rfbwp_fb_hc_bco' => '',
		'rfbwp_fb_hc_bci' => '',
		'rfbwp_fb_hc_bcc' => ''
	);

	$fb_table = 'rfbwp_options';
	$fb_options = get_option( $fb_table );
	$fb_book_id = isset( $fb_options[ 'books' ] ) && is_array( $fb_options[ 'books' ] ) ? count( $fb_options[ 'books' ] ) : 0;

	$new_flipbook = $_REQUEST[ 'flipbook' ];
	$new_flipbook = array_merge( $base_flipbook, $new_flipbook );

	$new_sh_id = strtolower( str_replace( ' ', '_', $new_flipbook[ 'rfbwp_fb_name' ] ) );
	foreach ( $fb_options[ 'books' ] as $book ) {
		if ( $book[ 'rfbwp_fb_name' ] != '' ) {
			$sh_id = strtolower( str_replace( ' ', '_', $book[ 'rfbwp_fb_name' ] ) );

			if ( $new_sh_id == $sh_id )
				$new_flipbook[ 'rfbwp_fb_name' ] = $new_flipbook[ 'rfbwp_fb_name' ] . ' (' . $fb_book_id . ')';
		}
	}

	unregister_setting( $fb_table, $fb_table );

	$fb_options[ 'books' ][ $fb_book_id ] = $new_flipbook;

	update_option( $fb_table, $fb_options );

	register_setting( $fb_table, $fb_table, 'mp_validate_options' );

	die(0);
}
