$(document).ready(function () {
	var sliderPrincipal = $('.j-slider-texto');

	console.log('listo');

	sliderPrincipal.slick({
		slidesToShow: 1,
		slidesToScroll: 1,
		arrows: true,
		fade: true,
		infinite: false,
		autoplay: true,
		autoplaySpeed: 4000,
		prevArrow: $('.js-prev'),
		nextArrow: $('.js-next'),
		responsive: [{
			breakpoint: 960,
			settings: {
				asNavFor: '.js-mobile-circular',
				adaptiveHeight: true
			}
		}]
	});

	$('.js-mobile-circular').slick({
		slidesToShow: 1,
		slidesToScroll: 1,
		asNavFor: sliderPrincipal,
		fade: true,
		arrows: false,
		infinite: false
	});

	$('.j-seleccionar').on('click', function (evento) {
		evento.preventDefault();

		var rotacion = $(this).attr('data-rotacion');

		$('.j-rotar').css({ transform: 'rotate(' + rotacion + 'deg)' });

		$(this).parent('.c-slider__item').siblings('.c-slider__item').find('.j-seleccionar').removeClass('is-active');
		$(this).addClass('is-active');

		$(this).parent('.c-slider__item').siblings('.c-slider__item').find('.j-seleccionar').css({ transform: 'scale(0.08) rotate(-' + rotacion + 'deg)' });
		$(this).css({ transform: 'scale(1) rotate(-' + rotacion + 'deg)' });

		sliderPrincipal.slick('slickGoTo', Number($(this).attr('data-slide')));
	});

	sliderPrincipal.on('afterChange', function (event, slick, currentSlide, nextSlide) {
		var accion = $('.j-seleccionar');
		var elemento = $('.c-slider__item:nth-child(' + (currentSlide + 1) + ')');

		accion.removeClass('is-active');
		elemento.find('.j-seleccionar').addClass('is-active');

		var rotacion = elemento.find('.j-seleccionar').attr('data-rotacion');

		$('.j-rotar').css({ transform: 'rotate(' + rotacion + 'deg)' });
		accion.css({ transform: 'scale(0.08) rotate(-' + rotacion + 'deg)' });

		$('.j-seleccionar.is-active').css({ transform: 'scale(1) rotate(-' + rotacion + 'deg)' });
	});
});